/*
 * Decompiled with CFR 0.152.
 */
package fme;

import fme.CBData;
import fme.CBData_Comum;
import fme.CBTabela;
import fme.CBTabela_ActivSector;
import fme.CFType;
import fme.CFType_Nif;
import fme.CFType_Num;
import fme.CHTabColModel;
import fme.CHValid_Grp;
import fme.CHValid_Msg;
import fme.CTabelas;
import fme.Frame_IdProm_4;
import fme.TabError;
import fme.TableKeyListener;
import fme.fmeFrame;
import java.awt.Component;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;

class CBTabela_Portfolio
extends CBTabela {
    Frame_IdProm_4 P;
    int tab_index = 0;
    boolean active = true;
    JComboBox jcReg = null;

    @Override
    public String getPagina() {
        return CBData.getPagina("IdProm_4", "IdProm_4_N", CBData.ListaOutrosBenef, this.tab_index);
    }

    CBTabela_Portfolio() {
        this.P = (Frame_IdProm_4)fmeFrame.Paginas.getPage("IdProm_4");
        if (this.P == null) {
            return;
        }
        this.initialize();
    }

    CBTabela_Portfolio(Frame_IdProm_4 p, int idx) {
        this.P = p;
        this.tab_index = idx;
        this.initialize();
    }

    void initialize() {
        this.P.cbd_portfolio = this;
        this.tag = "Portfolio";
        this.started = true;
        this.cols = new CHTabColModel[9];
        this.cols[0] = new CHTabColModel("n_ordem", "N\u00ba", true, false, true, null);
        this.cols[1] = new CHTabColModel("nif", "NIF", true, true, true, (CFType)new CFType_Nif());
        this.cols[2] = new CHTabColModel("produtor", "Produtor", true, true, true, null);
        this.cols[3] = new CHTabColModel("marcas", "Marcas", true, true, true, null);
        this.cols[4] = new CHTabColModel("tipo", "tipo (id)", true, true, false, null);
        this.cols[5] = new CHTabColModel("tipo_d", "<html>Tipo de<br/>Vinho</html>", false, true, true, null);
        this.cols[6] = new CHTabColModel("regiao", "Regi\u00e3o (id)", true, true, false, null);
        this.cols[7] = new CHTabColModel("regiao_d", "Regi\u00e3o", false, true, true, null);
        this.cols[8] = new CHTabColModel("qtd_ctr", "<html>Quantidade<br/>estimada<br/>(litros)</html>", true, true, true, (CFType)new CFType_Num());
        this.init_dados(6);
        this.init_handler(this.P.getJTable_Portfolio());
        this.P.getJTable_Portfolio().addKeyListener(new TableKeyListener(this));
        this.handler.width = this.P.getJScrollPane_Portfolio().getWidth() - 2;
        this.handler.set_col(0, 0.06, "C");
        this.handler.set_col_text(1, 0.11, "L");
        this.handler.set_col_text(2, 0.22, "L");
        this.handler.set_col_text(3, 0.22, "L");
        this.handler.set_col_comboS(5, 0.1, null, CTabelas.TipoProd, 1, 100);
        this.jcReg = this.handler.set_col_comboS(7, 0.12, null, CTabelas.Regioes, 1, 140);
        this.handler.set_col_text(8, 0.15, "R");
        this.handler.set_col_filter(7, new DefaultCellEditor(this.jcReg){

            @Override
            public Component getTableCellEditorComponent(JTable tab, Object val, boolean sel, int row, int col) {
                JComboBox c = (JComboBox)super.getTableCellEditorComponent(tab, val, sel, row, col);
                CBTabela_Portfolio.this._populateRegioes(c, row);
                return c;
            }
        });
        this.CheckPortfolioCondicoes(null);
    }

    void _populateRegioes(JComboBox c, int row) {
        if (!this.getColValue("tipo", row).equals("CST")) {
            CTabelas.Regioes._populateComboBox(c, 1);
        } else {
            c.removeAllItems();
            c.addItem("");
        }
        c.setSelectedItem(this.getColValue("regiao_d", row));
    }

    @Override
    void on_update(String colname, int nRow, String v) {
        if (colname.equals("tipo_d")) {
            String tipo = "";
            if (v.length() > 0) {
                tipo = CTabelas.TipoProd.lookup(1, v, 0);
            }
            this.setColValue("tipo", nRow, tipo);
            this._populateRegioes(this.jcReg, nRow);
            String w = this.jcReg.getSelectedItem().toString();
            this.setColValue("regiao_d", nRow, w);
            this.on_update("regiao_d", nRow, w);
        }
        if (colname.equals("tipo")) {
            String tipo_d = "";
            if (v.length() > 0) {
                tipo_d = CTabelas.TipoProd.lookup(0, v, 1);
            }
            this.setColValue("tipo_d", nRow, tipo_d);
        }
        if (colname.equals("regiao_d")) {
            String regiao = "";
            if (v.length() > 0) {
                regiao = CTabelas.Regioes.lookup(1, v, 0);
            }
            this.setColValue("regiao", nRow, regiao);
        }
        if (colname.equals("regiao")) {
            String regiao_d = "";
            if (v.length() > 0) {
                regiao_d = CTabelas.Regioes.lookup(0, v, 1);
            }
            this.setColValue("regiao_d", nRow, regiao_d);
        }
        this.numerar(0);
        if (CBData.Docs1 != null && CBData.Docs1.started) {
            CBData.Docs1.update_combos();
        }
    }

    @Override
    boolean on_del_row() {
        boolean res = this.on_del_row(false);
        this.numerar(0);
        if (CBData.Docs1 != null && CBData.Docs1.started) {
            CBData.Docs1.update_combos();
        }
        return res;
    }

    @Override
    String on_xml(String tag, int row, String v) {
        String s = "";
        return s;
    }

    CHValid_Grp validar(CHValid_Grp err_list, String Entidade) {
        boolean paraValidar;
        String titulo = "Portf\u00f3lio a comercializar";
        if (Entidade != null) {
            titulo = String.valueOf(titulo) + Entidade;
        }
        if (err_list == null) {
            err_list = new CHValid_Grp(this, titulo);
        }
        if (paraValidar = this.active) {
            if (this.isEmpty()) {
                err_list.add_msg(new CHValid_Msg("Portfolio", 'W', String.valueOf(titulo) + " - Lista vazia"));
            } else {
                int j = 0;
                while (j < this.dados.size()) {
                    if (!this.isRowEmpty(j)) {
                        String mask = this.getColValue("tipo", j).equals("CST") ? "-RRR---RR" : "-RRR-R-RR";
                        TabError[] e = this.isIncompletAll(j, mask.toString());
                        int ii = 0;
                        while (e != null && ii < e.length) {
                            err_list.add_msg(new CHValid_Msg((CBData_Comum)this, String.valueOf(titulo) + ": " + e[ii].msg("Linha %L incompleta: %T - %o"), e[ii].row, e[ii].col));
                            ++ii;
                        }
                    }
                    ++j;
                }
            }
        } else if (!this.isEmpty()) {
            err_list.add_msg(new CHValid_Msg("Portfolio", 'W', String.valueOf(titulo) + " - A preencher apenas por Prestadores de Servi\u00e7os e Distribuidores que promovam vinhos de terceiros."));
        }
        return err_list;
    }

    public void CheckPortfolioCondicoes(CBTabela_ActivSector activ_sector) {
        boolean toActivate = false;
        if (activ_sector == null || !activ_sector.started) {
            toActivate = false;
        } else {
            String cod = null;
            int i = 0;
            while (i < activ_sector.dados.size()) {
                cod = activ_sector.getColValue("actividade", i);
                if (cod != null && cod.equals("04")) {
                    toActivate = true;
                    break;
                }
                ++i;
            }
        }
        if (!toActivate) {
            this.P.getJTable_Portfolio().setEnabled(false);
            if (this.active) {
                while (!this.isEmpty()) {
                    this.del_row_at(0);
                }
            }
            this.active = false;
        } else {
            this.P.getJTable_Portfolio().setEnabled(true);
            this.active = true;
        }
        if (this.P.jButton_PortfolioAdd != null) {
            this.P.jButton_PortfolioAdd.setVisible(toActivate);
        }
        if (this.P.jButton_PortfolioDel != null) {
            this.P.jButton_PortfolioDel.setVisible(toActivate);
        }
        if (this.P.jButton_PortfolioIns != null) {
            this.P.jButton_PortfolioIns.setVisible(toActivate);
        }
        if (CBData.Docs1 != null && CBData.Docs1.started) {
            CBData.Docs1.update_combos();
        }
    }
}

